/*
 * Decompiled with CFR 0.152.
 */
package view;

import app.Application;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import util.Config;
import util.Logger;
import view.MainView;

public class Header
extends JDialog {
    static Logger logger = Logger.getLogger();
    private static final long serialVersionUID = 1L;
    private Application myApp;
    private MainView myMV;
    private Action confirmAction;
    private Action cancelAction;
    private Config myConfig;
    private JRadioButton DDF255Radio;
    private JRadioButton DDF0XARadio;
    private JRadioButton InlineRadio;
    private JCheckBox BinaryCheckBox;
    private JTextField FilenameText;
    private JTextField PartnumberText;
    private JTextField SerialnumberText;
    private JTextField ProductdateText;
    private JTextField AntennanameText;
    private JTextField AntennacodeText;
    private JTextField BeginFrequencyText;
    private JTextField EndFrequencyText;

    public Header(Application pApp, MainView pmw) {
        super(pmw, "Write Correction Data", true);
        logger.entry(4, "Header.Header");
        this.myApp = pApp;
        this.myMV = pmw;
        this.myConfig = Config.getConfig();
        this.createActions();
        this.createControls();
        this.pack();
        logger.exit(4, "Header.Header");
    }

    private void createActions() {
        logger.entry(4, "Header.createActions");
        this.confirmAction = new AbstractAction("O.K."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Header.this.confirm();
            }
        };
        this.cancelAction = new AbstractAction("Cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Header.this.setVisible(false);
            }
        };
    }

    private void createControls() {
        logger.entry(4, "Header.createControls");
        JPanel controlpanel = new JPanel();
        controlpanel.setLayout(new BoxLayout(controlpanel, 1));
        JPanel fpanel = new JPanel(new GridLayout(0, 2, 5, 5));
        fpanel.add(new JLabel("File Name:"));
        this.FilenameText = new JTextField();
        this.FilenameText.setText(this.myConfig.getParam("Filename"));
        fpanel.add(this.FilenameText);
        fpanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        controlpanel.add(fpanel);
        ButtonGroup typegroup = new ButtonGroup();
        this.DDF255Radio = new JRadioButton("DDF255");
        this.DDF0XARadio = new JRadioButton("DDF0XA");
        this.InlineRadio = new JRadioButton("Inline Code");
        typegroup.add(this.DDF255Radio);
        typegroup.add(this.DDF0XARadio);
        typegroup.add(this.InlineRadio);
        logger.log(5, "Filetype = " + this.myConfig.getParam("Filetype"));
        if (this.myConfig.getParam("Filetype").equals("DDF0XA")) {
            this.DDF0XARadio.setSelected(true);
            logger.log(5, "select DDF0XA");
        } else if (this.myConfig.getParam("Filetype").equals("Inline")) {
            this.InlineRadio.setSelected(true);
            logger.log(5, "select Inline");
        } else {
            this.DDF255Radio.setSelected(true);
            logger.log(5, "select DDF255");
        }
        Box typebox = new Box(1);
        JPanel typepanel = new JPanel(new GridLayout(0, 1, 5, 5));
        typepanel.add(this.DDF255Radio);
        typepanel.add(this.DDF0XARadio);
        typepanel.add(this.InlineRadio);
        typepanel.setBorder(BorderFactory.createTitledBorder("Select File Type"));
        typebox.add(typepanel);
        typebox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (this.myConfig.getParam("Unused01").equals("4711")) {
            controlpanel.add(typebox);
        } else {
            this.DDF255Radio.setSelected(true);
        }
        this.BinaryCheckBox = new JCheckBox("Create Binary (.bin)");
        logger.log(5, "DataFormat = " + this.myConfig.getParam("DataFormat"));
        if (this.myConfig.getParam("DataFormat").equals("binary")) {
            this.BinaryCheckBox.setSelected(true);
            logger.log(5, "select Binary Data");
        } else {
            this.BinaryCheckBox.setSelected(false);
            logger.log(5, "select no Binary Data");
        }
        Box datatypebox = new Box(0);
        JPanel datatypepanel = new JPanel(new GridLayout(1, 0, 5, 5));
        datatypepanel.add(this.BinaryCheckBox);
        datatypepanel.setBorder(BorderFactory.createTitledBorder("Select Data Format"));
        datatypebox.add(datatypepanel);
        datatypebox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (this.myConfig.getParam("Unused01").equals("4711")) {
            controlpanel.add(datatypebox);
        } else {
            this.BinaryCheckBox.setSelected(true);
        }
        JPanel headerpanel = new JPanel(new GridLayout(0, 2, 5, 5));
        Box headerbox = new Box(1);
        headerpanel.add(new JLabel("Part Number:"));
        this.PartnumberText = new JTextField();
        this.PartnumberText.setText(this.myConfig.getParam("Partnumber"));
        headerpanel.add(this.PartnumberText);
        headerpanel.add(new JLabel("Serial Number:"));
        this.SerialnumberText = new JTextField();
        this.SerialnumberText.setText(this.myConfig.getParam("Serialnumber"));
        headerpanel.add(this.SerialnumberText);
        headerpanel.add(new JLabel("Date (yyyy-MM-dd):"));
        this.ProductdateText = new JTextField();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(new Date());
        this.ProductdateText.setText(date);
        headerpanel.add(this.ProductdateText);
        headerpanel.add(new JLabel("Antenna Name:"));
        this.AntennanameText = new JTextField();
        this.AntennanameText.setText(this.myConfig.getParam("Antennaname"));
        headerpanel.add(this.AntennanameText);
        headerpanel.add(new JLabel("Antenna Code:"));
        this.AntennacodeText = new JTextField();
        this.AntennacodeText.setText(this.myConfig.getParam("Antennacode"));
        headerpanel.add(this.AntennacodeText);
        headerpanel.add(new JLabel("Start Frequency:"));
        this.BeginFrequencyText = new JTextField();
        this.BeginFrequencyText.setText(this.myConfig.getParam("BeginFrequency"));
        headerpanel.add(this.BeginFrequencyText);
        headerpanel.add(new JLabel("Stop Frequency:"));
        this.EndFrequencyText = new JTextField();
        this.EndFrequencyText.setText(this.myConfig.getParam("EndFrequency"));
        headerpanel.add(this.EndFrequencyText);
        headerpanel.setBorder(BorderFactory.createTitledBorder("Data Header"));
        headerbox.add(headerpanel);
        headerbox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        controlpanel.add(headerbox);
        JPanel acceptpanel = new JPanel(new GridLayout(0, 2, 5, 5));
        JButton OkButton = new JButton(this.confirmAction);
        JButton CancelButton = new JButton(this.cancelAction);
        acceptpanel.add(OkButton);
        acceptpanel.add(CancelButton);
        acceptpanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        controlpanel.add(acceptpanel);
        this.add(controlpanel);
        logger.exit(4, "Header.createControls");
    }

    private void confirm() {
        logger.entry(4, "Header.confirm");
        if (!this.checkDate()) {
            JOptionPane.showMessageDialog(this, "please insert a valid date!");
            logger.exit(4, "Header.confirm Date Error");
            return;
        }
        this.myConfig.setParam("Filename", this.FilenameText.getText());
        this.myConfig.setParam("Partnumber", this.PartnumberText.getText());
        this.myConfig.setParam("Serialnumber", this.SerialnumberText.getText());
        this.myConfig.setParam("Productdate", this.ProductdateText.getText());
        this.myConfig.setParam("Antennaname", this.AntennanameText.getText());
        this.myConfig.setParam("Antennacode", this.AntennacodeText.getText());
        this.myConfig.setParam("BeginFrequency", this.BeginFrequencyText.getText());
        this.myConfig.setParam("EndFrequency", this.EndFrequencyText.getText());
        if (this.DDF0XARadio.isSelected()) {
            this.myConfig.setParam("Filetype", "DDF0XA");
        } else if (this.InlineRadio.isSelected()) {
            this.myConfig.setParam("Filetype", "Inline");
        } else {
            this.myConfig.setParam("Filetype", "DDF255");
        }
        if (this.BinaryCheckBox.isSelected()) {
            this.myConfig.setParam("DataFormat", "binary");
        } else {
            this.myConfig.setParam("DataFormat", "ascii");
        }
        this.myApp.writeData();
        this.setVisible(false);
        logger.exit(4, "Header.confirm");
    }

    private boolean checkDate() {
        logger.entry(4, "Header.checkDate");
        boolean result = true;
        String dte = this.ProductdateText.getText();
        int i = 0;
        while (i < dte.length() && result) {
            if (i < 4) {
                if (!Character.isDigit(dte.charAt(i))) {
                    result = false;
                    logger.log(5, "year invalid at " + i + " " + dte.charAt(i));
                }
            } else if (i == 4) {
                if (dte.charAt(i) != '-') {
                    result = false;
                    logger.log(5, "delimiter invalid at " + i + " " + dte.charAt(i));
                }
            } else if (i < 7) {
                if (!Character.isDigit(dte.charAt(i))) {
                    result = false;
                    logger.log(5, "month invalid at " + i + " " + dte.charAt(i));
                }
            } else if (i == 7) {
                if (dte.charAt(i) != '-') {
                    result = false;
                    logger.log(5, "delimiter invalid at " + i + " " + dte.charAt(i));
                }
            } else if (i < 10) {
                if (!Character.isDigit(dte.charAt(i))) {
                    result = false;
                    logger.log(5, "day invalid at " + i + " " + dte.charAt(i));
                }
            } else {
                result = false;
                logger.log(5, "string is too long " + i + " " + dte.charAt(i));
            }
            ++i;
        }
        logger.exit(4, "Header.checkDate");
        return result;
    }
}

